/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13;

import lotus.domino.*; import djbuch.kapitel_06.*;

/**
 * DB2 Query View 
 * -> SQL Daten werden ber einen speziellen Notes View (QueryView)
 *    in Domino verfgbar gemacht.
 * 
 * Ldt eine SQL Ansicht, die in Domino als DB2Query View geladen wird
 * und zeigt die SQL Daten mit Domino Techniken an.
 * 
 * Hierbei basiert die Ansicht V_NON_DOMINO_SQL_k13 auf reinen SQL Daten.
 * Dagegen ldt die Ansicht V_DokumenteSQL_k13 SQL Daten aus DB2, die zuvor als DAV von Domino
 * nach DB2 sichtbar gemacht wurden.
 * Hieran lassen sich die Unterschiede erkennen, die sich fr den 
 * QueryView ergeben:
 * -> Stammen die Daten aus reinen SQL Daten, so stehen im Domino Document
 *    ViewEntry.getDocument() keine Items zur Verfgung.
 *    Nur ber getColumnValues knnen die SQL Daten geladen werden.
 *    entry.getDocument().getItems().size() liefert hierbei 0.
 * -> Stamm die Daten dagegen ursprnglich aus Domino und wurden per 
 *    DAV in DB2 sichtbar gemacht, so liefert ViewEntry.getDocument()
 *    das ursprngliche Document.
 *    entry.getDocument().getItems().size() liefert hierbei die Anzahl der
 *    Items im Document.
 * 
 * @author Thomas Ekert
 */
public class Db2QueryView implements Runnable {

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de:63148"; 		//null fr lokale Session
	private static final String USER = "Administrator/DJBUCH";	//null fr lokale Session
		
	public static void main(String[] args) {
		Db2QueryView db2QueryViewApplication = new Db2QueryView();
		Thread nt = new Thread(db2QueryViewApplication);
		nt.start();
	}

	public void run() {
		Session session = null;
		Database db = null;
		View view = null;
		ViewEntryCollection vec = null;
		ViewEntry entry = null, nextEntry = null;
		try {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
			db = session.getDatabase(session.getServerName(), "djbuch/djbuchdb2.nsf");
			
			view = db.getView("V_NON_DOMINO_SQL_k13");
			//view = db.getView("V_DokumenteSQL_k13");
			vec = view.getAllEntries();
			System.out.println ("Die Ansicht enthlt Dokumente: " + (view.getFirstDocument()!=null));
			System.out.println ("Die Ansicht enthlt " + vec.getCount() + " Elemente.");
			entry = vec.getFirstEntry();
			while (entry != null) {
				nextEntry = vec.getNextEntry();
				
				System.out.print (entry.getDocument().getItems().size() + " Items - ");
				System.out.print (entry.getDocument().getParentDatabase() + " ");
				System.out.println (" values = " + entry.getColumnValues());
				GC.recycle(entry);
				entry = nextEntry;
			}
		} catch (Exception e) {
			System.out.println("id = "
					+ (e instanceof NotesException ? ""
							+ ((NotesException) e).id : ""));
			e.printStackTrace();
		} finally {
			GC.recycle(db);
			GC.recycle(session);
		}
	}
}

/*

definition der SQL TABELLE, die im Domino View V_NON_DOMINO_SQL_k13 geladen wird.

CONNECT TO DOMINO;
CREATE TABLE DJBUCHDB2.NON_DOMINO_SQL_DATA ( ID BIGINT  NOT NULL  GENERATED ALWAYS AS IDENTITY (START WITH 0, INCREMENT BY 1, NO CACHE ) , TEXT VARCHAR (20) , ZAHL_INT BIGINT , ZAHL_DECIMAL DECIMAL (7, 3)  NOT NULL  , CONSTRAINT CC1130852963422 PRIMARY KEY ( ID)  ) ;
CONNECT RESET;

*/